'------------------------------------------------------------------
                   'Electrolab.ir
                   'DEVELOPED BY UNES ABBASZADE
'------------------------------------------------------------------

$regfile = "M8def.dat"
$crystal = 8000000                                          '11059200
$hwstack = 40
$swstack = 20
'$framesize = 40

'=== Declare sub routines
Declare Sub R_register
Declare Sub R_data
Declare Sub W_data
Declare Sub W_enable
Declare Sub Get_id
Declare Sub Ch_erase
Declare Sub Sec_erase

'=== Constante ===
Dim I As Byte
Dim D_bytes(8) As Byte
Dim B_bytes(8) As Byte
Dim Buffer(256) As Byte
Dim Read_reg(3) As Byte
Read_reg(1) = &H05
Read_reg(2) = &H35
Read_reg(3) = &H15
Dim A As Byte
Dim F As Byte

Const Write_enable = &H06
Const R_device_id2 = &H90
Const Wp_getid = 159
Const Ch_ereas = 96
Const Sec_erase = &H20


'=== Config hardware ===
Config Spi = Hard , Interrupt = Off , Data Order = Msb , Master = Yes , Polarity = High , Phase = 1 , Clockrate = 4 , Noss = 1
Config Pinb.2 = Output                                      'SS pin is output
Ss Alias Portb.2
A = 159


'===============================
Print "start"
Call W_enable
'Call Sec_erase

Waitms 100
Call W_enable
Call W_data
Waitms 1000
Do
Call W_enable
Print "read id"
Call Get_id
Print
Print "manufacturer id = " ; D_bytes(1)
Print
Print "memory type     = " ; D_bytes(2)
Print
Print "memory capacity = " ; D_bytes(3)
Print
Waitms 2000
Call W_enable
Call R_register
Print "read register"
Print "register1 = " ; D_bytes(1)
If D_bytes(1).0 = 0 Then
Print "not busy"
Print
Else
Print "busy"
Waitms 1000
Print
End If
B_bytes(1) = 2                                              'addres
B_bytes(2) = 0
B_bytes(3) = 2
B_bytes(4) = 0
B_bytes(5) = 5
Call W_data

B_bytes(1) = 2                                              'addres
B_bytes(2) = 0
B_bytes(3) = 2
B_bytes(4) = 0

Call R_data
Print "read data from address 512"
For I = 1 To 4
Print Buffer(i)
Next
Waitms 2000

Loop
End

                                                    '

'=== Sub routines ===
Sub Get_id
B_bytes(1) = Wp_getid
Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(1) , 1
    Spiin D_bytes(1) , 3
Set Ss
End Sub

'=============================READ REGISTER====================================
Sub R_register
Spiinit
Waitms 10
Set Ss
Reset Ss                                                    'Manual controle SS pin, set low before shifting in/out the bytes
    Spiout Read_reg(1) , 1                                  'First shiftout the register to be read
    Spiin D_bytes(1) , 1                                    'Read back the bytes from SPI sended by spi flash
Set Ss                                                      'Set SS back to high level
End Sub
'==============================WRITE ENABLE=====================================
Sub W_enable
B_bytes(3) = 6
Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(3) , 1
Set Ss
End Sub

'=============================READ DATA========================================
Sub R_data

Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(1) , 4
    Spiin Buffer(1) , 5
Set Ss
End Sub
'===========================WRITE REGISTER=====================================
Sub W_data

Print "Write page1..."
Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(1) , 5

Set Ss
End Sub
'===========================SECTOR ERASE========================================
Sub Sec_erase
B_bytes(1) = 216                                            'addres
B_bytes(2) = 0
B_bytes(3) = 2
B_bytes(4) = 0

Print "Sector erase..."
Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(1) , 4

Set Ss
End Sub

'=============================CHIP ERASE=======================================

Sub Ch_erase
B_bytes(3) = 199
Print "chip erase..."
Spiinit
Waitms 10
Set Ss
Reset Ss
    Spiout B_bytes(3) , 1
Set Ss
End Sub